;;; org-autofocus.el --- Mark Forster's Auto Focus system for Org  -*- lexical-binding: t; -*-

;; Copyright (C) 2020 David Owen

;; Author: David Owen <dsowen@fugue88.ws>
;; Keywords: autofocus
;; Package-Requires: (org)

;;; Commentary:

;;; Code:

(require 'calendar)

(require 'org-agenda)

(define-derived-mode org-autofocus-mode special-mode "Org AF" nil
  (let ((inhibit-read-only t)
        (date (calendar-current-date))
        tasks)
    (setq buffer-undo-list t)
    (dolist (f (org-agenda-files))
      (catch 'nextfile
	(org-check-agenda-file f)
	(setq tasks (nconc (org-agenda-get-day-entries f date :todo) tasks))))
    (dolist (task tasks)
      (insert task "\n"))))

;;;###autoload
(defun org-autofocus ()
  "Show the AutoFocus buffer; create it if necessary."
  (interactive)
  (pop-to-buffer (get-buffer-create "*Org AutoFocus*"))
  (org-autofocus-mode))

(provide 'org-autofocus)
;;; org-autofocus.el ends here
