;;; org-autofocus.el --- Mark Forster's Auto Focus system for Org  -*- lexical-binding: t; -*-

;; Copyright (C) 2020 David Owen

;; Author: David Owen <dsowen@fugue88.ws>
;; Keywords: autofocus
;; Package-Requires: (org)

;;; Commentary:

;;; Code:

(require 'calendar)
(require 'eieio)
(require 'ewoc)

(require 'org-agenda)


(defvar-local org-af--ewoc nil)


(defclass org-af--task ()
  ((org :initarg :org)
   (marked :initform nil)))


(defun org-af--pp (obj)
  "Print the task OBJ in the current buffer at point."
  (with-slots (org marked) obj
    (insert (if marked "*" " ") " " org)))


(define-derived-mode org-autofocus-mode special-mode "Org AF" nil
  (let ((inhibit-read-only t)
        (date (calendar-current-date))
        tasks)
    (setq buffer-undo-list t)

    (dolist (f (org-agenda-files))
      (catch 'nextfile
	(org-check-agenda-file f)
	(setq tasks (nconc (org-agenda-get-day-entries f date :todo) tasks))))

    (setq org-af--ewoc (ewoc-create 'org-af--pp "header" "footer"))
    (dolist (task tasks)
      (ewoc-enter-last org-af--ewoc (make-instance 'org-af--task :org task)))))


(defun org-af--mark ()
  "Toggle whether the task at point is marked."
  (interactive)
  (let* ((node (ewoc-locate org-af--ewoc))
         (obj (ewoc-data node)))
    (with-slots (marked) obj
      (setf marked (not marked))
      (ewoc-invalidate org-af--ewoc node))))


(define-key org-autofocus-mode-map "." 'org-af--mark)


;;;###autoload
(defun org-autofocus ()
  "Show the AutoFocus buffer; create it if necessary."
  (interactive)
  (pop-to-buffer (get-buffer-create "*Org AutoFocus*"))
  (org-autofocus-mode))


(provide 'org-autofocus)
;;; org-autofocus.el ends here
