from random import shuffle


class Player(object):

    def __init__(self, player_count, player_num, role):
        self.count = player_count
        self.num = player_num
        self.role = role

    def reveal_spies(self, spies):
        """If this player is a spy, this method will be called to reveal the identities
        of *all* the spies (including this player).

        It is passed as an array of IDs.

        """
        pass

    def propose_team(self, count):
        """Asks the player to propose a team as a team-lead.

        Must return an array of `count` unique IDs.  The proposed team may
        include the player, but does not need to.

        """
        team = list(range(self.count))
        shuffle(team)
        return team[:count]

    def approve_team(self, team):
        """Asks the player to vote on a proposed team.

        True indicates approval, False disapproval.  The player will be asked
        to vote on all teams, even one that it proposes.

        """
        return True

    def observe_team_vote(self, approved, votes):
        """Allows the player to observe the outcome of a vote to approve a proposed
        team.

        The final result is given as `approved`, and individual votes (ordered
        by player ID) are given as an array as `votes`.

        """
        pass

    def perform_mission(self):
        """If this player is a spy, called to ask the player whether to fail the
        mission.

        True indicates that this player will not cause a failure, False that it
        will cause a failure.

        Note that some missions require 2 players to attempt a mission failure
        to actually fail the mission.

        """
        return False

    def observe_mission(self, success, failures):
        """Allows the player to observe the outcome of a mission.

        The final result is given as `success`.  The number of failures is
        given (as an integer) as `failures`.

        """
        pass

    def observe_game(self, success):
        """Allows the player to observe the outcome of the game.

        True indicates the Resistance won, False the Government (spies).

        """
        pass
